/*
 *
 *  Copyright (C) 2010-2011 Amr Thabet <amr.thabet@student.alx.edu.eg>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to Amr Thabet 
 *  amr.thabet@student.alx.edu.eg
 *
 */
#include "x86emu.h"
Thread::Thread(){
            //this for the parser as we don't need anything from the thread just work in pointers    
}

Process* Thread::GetProcess(){
     return process;
};
Thread::Thread(dword neip,Process &s)
{
     // initialize the thread
     this->Eip=neip;
     log=new Log(neip);
     process=&s;
     //create the stack
     //it's created from tests only and I didn't use the Heap Commit & Reserve
     //I use it from 0x00126000 to 0x0013000
     seh_enable=true;
     dword x =(dword)malloc(0xA000);
     memset((void*)x,0,0xA000);
     stack=new Stack(*this);
     mem=process->SharedMem;
     mem->add_pointer(x,0x00126000,0xA000);
     Exx[4]=0x0012FF90;                                //esp
     Exx[5]=0x0012FF94;                                //ebp
     //preparing the TIB,TEB
     CreateTEB();
};

int Thread::updateflags(dword dest,dword src,dword result,int flags){
    bool x=false;
    if (EFlags & EFLG_CF && (flags != UPDATEFLAGS_ADD) && (flags != UPDATEFLAGS_SUB)) x=true;
    this->EFlags=EFLG_SYS;
    
    if (result==0) EFlags |=EFLG_ZF;                                      //zero
    if ((result >> 31)==1) EFlags |=EFLG_SF;                             //negative
    if ((flags == UPDATEFLAGS_ADD) && (dest < 0x80000000) && (result >0x80000000))EFlags |=EFLG_OF;        //overflow of positive
    if ((flags == UPDATEFLAGS_SUB) && (dest > 0x80000000) && (result <0x80000000))EFlags |=EFLG_OF;        //overflow of negative
    //if (result & 1) EFlags |=EFLG_PF; //odd
    if ((result & 0xFFFFFF00) > (dest & 0xFFFFFF00))EFlags |=EFLG_AF;   //2F-->31 (the tens added by 1)
    if ((flags == UPDATEFLAGS_ADD) && (dest > result))EFlags |=EFLG_CF |EFLG_AF;        //overflow of positive
    if ((flags == UPDATEFLAGS_SUB) && (result > dest))EFlags |=EFLG_CF |EFLG_AF;        //overflow of negative
    //if ((flags == UPDATEFLAGS_CMP) && result > 0x80000000) EFlags |=EFLG_CF;       //become negative mean less
    //if (result < dest) EFlags |=EFLG_CF;             //0xFF + 5 == 4 & CF=1   //(flags == UPDATEFLAGS_ADD) && 
    int n;
    //this loop determines how many bits with value ==1 in the result in binary format like 101 --> 2 bits of "1"
     for (int i=0;i<32;i++){
        if (result & 1)n++;  
        result=result >> 1;  
     };
    //if the number of bits "1" is even we will set the PF flag
    if ((n & 1)==0)EFlags |=EFLG_PF;
    if (x) EFlags |= EFLG_CF;
};
void Thread::CreateTEB(){
     tib=(TIB*)malloc(sizeof(TEB)+sizeof(TIB));
     memset(tib,0,sizeof(TEB)+sizeof(TIB));
     teb=(TEB*)((dword)tib+(dword)sizeof(TIB));
     tib->ExceptionList=(PEXCEPTION_REGISTRATION_RECORD*)0x0012FFC4;
     int n=0xFFFFFFFF;                                              //End of SEH Chain
     mem->write_virtual_mem((dword)tib->ExceptionList,(dword)4,(char*)&n);
     mem->write_virtual_mem((dword)(tib->ExceptionList+4),(dword)4,(char*)&n);
     tib->TIB=0x7FFDF000;                                           //pointer to SEH Chain
     teb->Peb=(PEB*)0x7FFD5000;
     this->fs=0x7FFDF000;                                          //set the fs segment to this place
     mem->add_pointer((dword)tib,0x7FFDF000,sizeof(TEB)+sizeof(TIB));
     dword ptr=*mem->read_virtual_mem(GetFS());
};
dword Thread::GetFS(){
      return fs;
};
